<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.7.0
 */

use JupiterX_Core\sellkit\Modules\Order_Details\Module;

defined( 'ABSPATH' ) || exit;

?>

<div class="woocommerce-order">

	<?php
	if ( $order ) {

		do_action( 'woocommerce_before_thankyou', $order->get_id() );
	}
		?>

		<?php if ( $order && $order->has_status( 'failed' ) ) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

			<ul <?php echo $this->get_render_attribute_string( 'details-order-content' ); ?> >
				<?php
					add_filter( 'sellkit_global_thankyou', '__return_true' );
					foreach ( $fields as $field ) {
						Sellkit_Elementor_Order_Details_Module::render_field( $this, $field );
					}
				?>
			</ul>

		<?php endif; ?>


</div>
