/*! For license information please see editor-global-classes.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts":function(e,s,t){t.r(s),t.d(s,{fetchCssClassUsage:function(){return fetchCssClassUsage}});var a=t("./packages/packages/core/editor-global-classes/src/api.ts"),r=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts");const fetchCssClassUsage=async()=>{const e=await a.apiClient.usage();return(0,r.transformData)(e?.data?.data||{})}},"./packages/packages/core/editor-global-classes/src/api.ts":function(e,s,t){t.r(s),t.d(s,{API_ERROR_CODES:function(){return c},apiClient:function(){return l}});var a=t("@elementor/http-client");const r="/global-classes",o="elementor/v1",n=`${r}/usage`,l={usage:()=>(0,a.httpService)().get(`${o}${n}`),all:(e="preview")=>(0,a.httpService)().get(`${o}${r}`,{params:{context:e}}),publish:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"frontend"}}),saveDraft:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"preview"}})},c={DUPLICATED_LABEL:"DUPLICATED_LABEL"}},"./packages/packages/core/editor-global-classes/src/capabilities.ts":function(e,s,t){t.r(s),t.d(s,{UPDATE_CLASS_CAPABILITY_KEY:function(){return r},getCapabilities:function(){return getCapabilities}});var a=t("@elementor/editor-v1-adapters");const r="elementor_global_classes_update_class",getCapabilities=()=>{if((0,a.isExperimentActive)("global_classes_should_enforce_capabilities"))return{update:r,create:r,delete:r,updateProps:r}}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx":function(e,s,t){t.r(s),t.d(s,{ClassItem:function(){return ClassItem}});var a=t("react"),r=t("@elementor/editor-styles-repository"),o=t("@elementor/editor-ui"),n=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts"),d=t("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),p=t("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const ClassItem=({id:e,label:s,renameClass:t,selected:r,disabled:m,sortableTriggerProps:h,showSortIndicator:b})=>{const f=(0,a.useRef)(null),{ref:y,openEditMode:k,isEditing:v,error:C,getProps:x}=(0,o.useEditable)({value:s,onSubmit:t,validation:validateLabel}),[_,E]=(0,a.useState)(""),{openDialog:w}=(0,d.useDeleteConfirmation)(),S=(0,l.usePopupState)({variant:"popover",disableAutoFocus:!0}),I=(_===e||r||S.isOpen)&&!m;return a.createElement(a.Fragment,null,a.createElement(l.Stack,{p:0},a.createElement(o.WarningInfotip,{open:Boolean(C),text:C??"",placement:"bottom",width:f.current?.getBoundingClientRect().width,offset:[0,-15]},a.createElement(u,{ref:f,dense:!0,disableGutters:!0,showSortIndicator:b,showActions:I||v,shape:"rounded",onDoubleClick:k,selected:I,disabled:m,focusVisibleClassName:"visible-class-item"},a.createElement(p.SortableTrigger,h),a.createElement(g,{isActive:v,isError:!!C},v?a.createElement(o.EditableField,_extends({ref:y,as:l.Typography,variant:"caption"},x())):a.createElement(o.EllipsisWithTooltip,{title:s,as:l.Typography,variant:"caption"})),a.createElement(l.Box,{className:"class-item-locator"},a.createElement(i.CssClassUsageTrigger,{id:e,onClick:E})),a.createElement(l.Tooltip,{placement:"top",className:"class-item-more-actions",title:(0,c.__)("More actions","elementor")},a.createElement(l.IconButton,_extends({size:"tiny"},(0,l.bindTrigger)(S),{"aria-label":"More actions"}),a.createElement(n.DotsVerticalIcon,{fontSize:"tiny"})))))),a.createElement(l.Menu,_extends({},(0,l.bindMenu)(S),{anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"}}),a.createElement(o.MenuListItem,{sx:{minWidth:"160px"},onClick:()=>{S.close(),k()}},a.createElement(l.Typography,{variant:"caption",sx:{color:"text.primary"}},(0,c.__)("Rename","elementor"))),a.createElement(o.MenuListItem,{onClick:()=>{S.close(),w({id:e,label:s})}},a.createElement(l.Typography,{variant:"caption",sx:{color:"error.light"}},(0,c.__)("Delete","elementor")))))},u=(0,l.styled)(l.ListItemButton,{shouldForwardProp:e=>!["showActions","showSortIndicator"].includes(e)})(({showActions:e,showSortIndicator:s})=>`\n    min-height: 36px;\n\n    &.visible-class-item {\n      box-shadow: none !important;\n    }\n\n    .class-item-locator {\n      visibility: hidden;\n    }\n\n    .class-item-sortable-trigger {\n      visibility: ${s&&e?"visible":"hidden"};\n    }\n\n    &:hover:not(:disabled) {\n      .class-item-locator {\n        visibility: visible;\n      }\n\n      .class-item-sortable-trigger {\n        visibility: ${s?"visible":"hidden"};\n      }\n    }\n  `),g=(0,l.styled)(l.Box,{shouldForwardProp:e=>!["isActive","isError"].includes(e)})(({theme:e,isActive:s,isError:t})=>({display:"flex",width:"100%",flexGrow:1,borderRadius:e.spacing(.5),border:getIndicatorBorder({isActive:s,isError:t,theme:e}),padding:`0 ${e.spacing(1)}`,marginLeft:s?e.spacing(1):0,minWidth:0})),getIndicatorBorder=({isActive:e,isError:s,theme:t})=>s?`2px solid ${t.palette.error.main}`:e?`2px solid ${t.palette.secondary.main}`:"none",validateLabel=e=>{const s=(0,r.validateStyleLabel)(e,"rename");return s.isValid?null:s.errorMessage}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx":function(e,s,t){t.r(s),t.d(s,{ClassManagerButton:function(){return ClassManagerButton}});var a=t("react"),r=t("@elementor/editor-documents"),o=t("@elementor/editor-styles-repository"),n=t("@elementor/editor-ui"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),d=t("./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts"),p=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),u=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),g=t("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx");const trackGlobalClassesButton=()=>{(0,p.trackGlobalClasses)({event:"classManagerOpened",source:"style-panel"})},ClassManagerButton=()=>{const e=(0,r.__useActiveDocument)(),{open:s}=(0,u.usePanelActions)(),{save:t}=(0,r.__useActiveDocumentActions)(),{open:m,close:h,isOpen:b}=(0,n.useDialog)(),{prefetchClassesUsage:f}=(0,d.usePrefetchCssClassUsage)(),{userCan:y}=(0,o.useUserStylesCapability)();if(!y(i.globalClassesStylesProvider.getKey()).update)return null;return a.createElement(a.Fragment,null,a.createElement(l.Tooltip,{title:(0,c.__)("Class Manager","elementor"),placement:"top"},a.createElement(l.IconButton,{size:"tiny",onClick:()=>{e?.isDirty?m():(s(),trackGlobalClassesButton(),(0,p.trackGlobalClasses)({event:"classManagerOpened",source:"style-panel"}),f())},sx:{marginInlineEnd:-.75}},a.createElement(g.FlippedColorSwatchIcon,{fontSize:"tiny"}))),b&&a.createElement(n.SaveChangesDialog,null,a.createElement(n.SaveChangesDialog.Title,null,(0,c.__)("You have unsaved changes","elementor")),a.createElement(n.SaveChangesDialog.Content,null,a.createElement(n.SaveChangesDialog.ContentText,{sx:{mb:2}},(0,c.__)("To open the Class Manager, save your page first. You can't continue without saving.","elementor"))),a.createElement(n.SaveChangesDialog.Actions,{actions:{cancel:{label:(0,c.__)("Stay here","elementor"),action:h},confirm:{label:(0,c.__)("Save & Continue","elementor"),action:async()=>{await t(),h(),s(),trackGlobalClassesButton(),f()}}}})))}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx":function(e,s,t){t.r(s),t.d(s,{ClassManagerIntroduction:function(){return ClassManagerIntroduction}});var a=t("react"),r=t("@elementor/editor-current-user"),o=t("@elementor/editor-ui"),n=t("@elementor/ui"),l=t("@wordpress/i18n");const ClassManagerIntroduction=()=>{const[e,s]=(0,r.useSuppressedMessage)("global-class-manager"),[t,c]=(0,a.useState)(!e);return a.createElement(o.IntroductionModal,{open:t,title:(0,l.__)("Class Manager","elementor"),handleClose:e=>{e||s(),c(!1)}},a.createElement(n.Image,{sx:{width:"100%",aspectRatio:"16 / 9"},src:"https://assets.elementor.com/packages/v1/images/class-manager-intro.svg",alt:""}),a.createElement(IntroductionContent,null))},IntroductionContent=()=>a.createElement(n.Box,{p:3},a.createElement(n.Typography,{variant:"body2"},(0,l.__)("The Class Manager lets you see all the classes you've created, plus adjust their priority, rename them, and delete unused classes to keep your CSS structured.","elementor")),a.createElement("br",null),a.createElement(n.Typography,{variant:"body2"},(0,l.__)("Remember, when editing an item within a specific class, any changes you make will apply across all elements in that class.","elementor")))},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx":function(e,s,t){t.r(s),t.d(s,{ClassManagerPanel:function(){return ClassManagerPanel},panel:function(){return D},usePanelActions:function(){return P}});var a=t("react"),r=t("@elementor/editor-documents"),o=t("@elementor/editor-panels"),n=t("@elementor/editor-ui"),l=t("@elementor/editor-v1-adapters"),c=t("@elementor/icons"),i=t("@elementor/query"),d=t("@elementor/store"),p=t("@elementor/ui"),u=t("@wordpress/i18n"),g=t("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),m=t("./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts"),h=t("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),b=t("./packages/packages/core/editor-global-classes/src/save-global-classes.tsx"),f=t("./packages/packages/core/editor-global-classes/src/store.ts"),y=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx"),k=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx"),v=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx"),C=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),x=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx"),_=t("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts"),E=t("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),w=t("./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx"),S=t("./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const I="global-classes-manager",{panel:D,usePanelActions:P}=(0,o.__createPanel)({id:I,component:ClassManagerPanel,allowedEditModes:["edit",I],onOpen:()=>{(0,l.changeEditMode)(I),(0,S.blockPanelInteractions)()},onClose:async()=>{(0,l.changeEditMode)("edit"),await(()=>{const e=(0,r.getCurrentDocument)();return(0,r.getV1DocumentsManager)().invalidateCache(),(0,l.__privateRunCommand)("editor/documents/switch",{id:e?.id,shouldScroll:!1,shouldNavigateToDefaultRoute:!1})})(),(0,S.unblockPanelInteractions)()},isOpenPreviousElement:!0});function ClassManagerPanel(){const e=(0,m.useDirtyState)(),{close:s}=P(),{open:t,close:r,isOpen:l}=(0,n.useDialog)(),{mutateAsync:c,isPending:i}=usePublish();return usePreventUnload(),a.createElement(n.ThemeProvider,null,a.createElement(p.ErrorBoundary,{fallback:a.createElement(ErrorBoundaryFallback,null)},a.createElement(o.Panel,null,a.createElement(C.SearchAndFilterProvider,null,a.createElement(o.PanelHeader,null,a.createElement(p.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},a.createElement(p.Stack,{width:"100%",direction:"row",gap:1},a.createElement(o.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},a.createElement(E.FlippedColorSwatchIcon,{fontSize:"inherit"}),(0,u.__)("Class Manager","elementor")),a.createElement(TotalCssClassCounter,null)),a.createElement(CloseButton,{sx:{marginLeft:"auto"},disabled:i,onClose:()=>{e?t():s()}}))),a.createElement(o.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},a.createElement(p.Box,{px:2,pb:1},a.createElement(p.Stack,{direction:"row",justifyContent:"spaceBetween",gap:.5,sx:{pb:.5}},a.createElement(p.Box,{sx:{flexGrow:1}},a.createElement(v.ClassManagerSearch,null)),a.createElement(k.CssClassFilter,null)),a.createElement(y.ActiveFilters,null)),a.createElement(p.Divider,null),a.createElement(p.Box,{px:2,sx:{flexGrow:1,overflowY:"auto"}},a.createElement(w.GlobalClassesList,{disabled:i}))),a.createElement(o.PanelFooter,null,a.createElement(p.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",onClick:c,disabled:!e,loading:i},(0,u.__)("Save changes","elementor")))))),a.createElement(x.ClassManagerIntroduction,null),l&&a.createElement(n.SaveChangesDialog,null,a.createElement(p.DialogHeader,{onClose:r,logo:!1},a.createElement(n.SaveChangesDialog.Title,null,(0,u.__)("You have unsaved changes","elementor"))),a.createElement(n.SaveChangesDialog.Content,null,a.createElement(n.SaveChangesDialog.ContentText,null,(0,u.__)("You have unsaved changes in the Class Manager.","elementor")),a.createElement(n.SaveChangesDialog.ContentText,null,(0,u.__)("To avoid losing your updates, save your changes before leaving.","elementor"))),a.createElement(n.SaveChangesDialog.Actions,{actions:{discard:{label:(0,u.__)("Discard","elementor"),action:()=>{(0,d.__dispatch)(f.slice.actions.resetToInitialState({context:"frontend"})),r()}},confirm:{label:(0,u.__)("Save & Continue","elementor"),action:async()=>{await c(),r(),s()}}}})))}const CloseButton=({onClose:e,...s})=>a.createElement(p.IconButton,_extends({size:"small",color:"secondary",onClick:e,"aria-label":"Close"},s),a.createElement(c.XIcon,{fontSize:"small"})),ErrorBoundaryFallback=()=>a.createElement(p.Box,{role:"alert",sx:{minHeight:"100%",p:2}},a.createElement(p.Alert,{severity:"error",sx:{mb:2,maxWidth:400,textAlign:"center"}},a.createElement("strong",null,(0,u.__)("Something went wrong","elementor")))),usePreventUnload=()=>{const e=(0,m.useDirtyState)();(0,a.useEffect)(()=>{const handleBeforeUnload=s=>{e&&s.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])},usePublish=()=>(0,i.useMutation)({mutationFn:()=>(0,b.saveGlobalClasses)({context:"frontend"}),onSuccess:async()=>{(0,r.setDocumentModifiedStatus)(!1),(0,_.hasDeletedItems)()&&await(0,_.onDelete)()}}),TotalCssClassCounter=()=>{const e=(0,h.useFilters)(),s=(0,g.useClassesOrder)();return a.createElement(p.Chip,{size:"small",label:e?`${e.length} / ${s?.length}`:s?.length})}},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts":function(e,s,t){t.r(s),t.d(s,{deleteClass:function(){return deleteClass},hasDeletedItems:function(){return hasDeletedItems},onDelete:function(){return onDelete}});var a=t("@elementor/store"),r=t("./packages/packages/core/editor-global-classes/src/store.ts"),o=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts");let n=!1;const deleteClass=e=>{(0,o.trackGlobalClasses)({event:"classDeleted",classId:e,runAction:()=>{(0,a.__dispatch)(r.slice.actions.delete(e)),n=!0}})},onDelete=async()=>{n=!1},hasDeletedItems=()=>n},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx":function(e,s,t){t.r(s),t.d(s,{DeleteConfirmationProvider:function(){return DeleteConfirmationProvider},useDeleteConfirmation:function(){return useDeleteConfirmation}});var a=t("react"),r=t("@elementor/editor-ui"),o=t("@elementor/ui"),n=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),c=t("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts");const i=(0,a.createContext)(null),DeleteConfirmationProvider=({children:e})=>{const[s,t]=(0,a.useState)(null);return a.createElement(i.Provider,{value:{openDialog:e=>{t(e)},closeDialog:()=>{t(null)},dialogProps:s}},e,!!s&&a.createElement(DeleteClassDialog,s))},DeleteClassDialog=({label:e,id:s})=>{const{closeDialog:t}=useDeleteConfirmation(),{data:{total:i,content:d}}=(0,l.useCssClassUsageByID)(s),p=i&&d.length?(0,n.__)("Will permanently remove it from your project and may affect the design across all elements using it. Used %1 times across %2 pages. This action cannot be undone.","elementor").replace("%1",i.toString()).replace("%2",d.length.toString()):(0,n.__)("Will permanently remove it from your project and may affect the design across all elements using it. This action cannot be undone.","elementor");return a.createElement(r.ConfirmationDialog,{open:!0,onClose:t},a.createElement(r.ConfirmationDialog.Title,null,(0,n.__)("Delete this class?","elementor")),a.createElement(r.ConfirmationDialog.Content,null,a.createElement(r.ConfirmationDialog.ContentText,null,(0,n.__)("Deleting","elementor"),a.createElement(o.Typography,{variant:"subtitle2",component:"span"}," ",e," "),p)),a.createElement(r.ConfirmationDialog.Actions,{onClose:t,onConfirm:()=>{t(),(0,c.deleteClass)(s)}}))},useDeleteConfirmation=()=>{const e=(0,a.useContext)(i);if(!e)throw new Error("useDeleteConfirmation must be used within a DeleteConfirmationProvider");return e}},"./packages/packages/core/editor-global-classes/src/components/class-manager/duplicate-label-dialog.tsx":function(e,s,t){t.r(s),t.d(s,{DuplicateLabelDialog:function(){return DuplicateLabelDialog}});var a=t("react"),r=t("@elementor/editor-ui"),o=t("@elementor/icons"),n=t("@elementor/ui"),l=t("@wordpress/i18n");const c="DUP_",DuplicateLabelDialog=({modifiedLabels:e,onApprove:s})=>a.createElement(a.Fragment,null,a.createElement(n.DialogHeader,{logo:!1},a.createElement(n.Box,{display:"flex",alignItems:"center",gap:1},a.createElement(n.Icon,{color:"secondary"},a.createElement(o.InfoCircleFilledIcon,{fontSize:"medium"})),a.createElement(n.Typography,{variant:"subtitle1"},(0,l.__)("We've published your page and updated class names.","elementor")))),a.createElement(n.DialogContent,null,a.createElement(n.Stack,{spacing:2,direction:"column"},a.createElement(n.Typography,{variant:"body2"},(0,l.__)("Some new classes used the same names as existing ones. To prevent conflicts, we added the prefix","elementor"),a.createElement("strong",null," ",c)),a.createElement(n.Box,null,a.createElement(n.Box,{sx:{width:"100%",display:"flex",gap:2,alignItems:"flex-start"}},a.createElement(n.Typography,{variant:"subtitle2",sx:{fontWeight:"bold",flex:1,flexShrink:1,flexGrow:1,minWidth:0}},(0,l.__)("Before","elementor")),a.createElement(n.Typography,{variant:"subtitle2",sx:{minWidth:"200px",fontWeight:"bold",flexShrink:0,flexGrow:0,width:"200px",maxWidth:"200px"}},(0,l.__)("After","elementor"))),a.createElement(n.Divider,{sx:{mt:.5,mb:.5}}),a.createElement(n.Stack,{direction:"column",gap:.5,sx:{pb:2}},Object.values(e).map(({original:e,modified:s},t)=>a.createElement(n.Box,{key:t,sx:{width:"100%",display:"flex",gap:2,alignItems:"flex-start"}},a.createElement(n.Box,{sx:{flex:1,flexShrink:1,flexGrow:1,minWidth:0}},a.createElement(r.EllipsisWithTooltip,{title:e},a.createElement(n.Typography,{variant:"body2",sx:{color:"text.secondary"}},e))),a.createElement(n.Box,{sx:{minWidth:"200px",flexShrink:0,flexGrow:0,width:"200px",maxWidth:"200px"}},a.createElement(r.EllipsisWithTooltip,{title:s},a.createElement(n.Typography,{variant:"body2",sx:{color:"text.primary"}},s)))))),a.createElement(n.Box,null,a.createElement(n.Alert,{severity:"info",size:"small",color:"secondary"},a.createElement("strong",null,(0,l.__)("Your designs and classes are safe.","elementor")),(0,l.__)("Only the prefixes were added. Find them in Class Manager by searching","elementor"),a.createElement("strong",null,c)))))),a.createElement(n.DialogActions,null,a.createElement(n.Button,{color:"secondary",variant:"text",onClick:()=>{localStorage.setItem("elementor-global-classes-search",c),s?.(),(0,r.closeDialog)()}},(0,l.__)("Go to Class Manager","elementor")),a.createElement(n.Button,{color:"secondary",variant:"contained",onClick:r.closeDialog},(0,l.__)("Done","elementor"))))},"./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx":function(e,s,t){t.r(s),t.d(s,{FlippedColorSwatchIcon:function(){return FlippedColorSwatchIcon}});var a=t("react"),r=t("@elementor/icons");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const FlippedColorSwatchIcon=({sx:e,...s})=>a.createElement(r.ColorSwatchIcon,_extends({sx:{transform:"rotate(90deg)",...e}},s))},"./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx":function(e,s,t){t.r(s),t.d(s,{GlobalClassesList:function(){return GlobalClassesList}});var a=t("react"),r=t("@elementor/store"),o=t("@elementor/ui"),n=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),c=t("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),i=t("./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts"),d=t("./packages/packages/core/editor-global-classes/src/store.ts"),p=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),u=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),g=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx"),m=t("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),h=t("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),b=t("./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx"),f=t("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");const GlobalClassesList=({disabled:e})=>{const{search:{debouncedValue:s}}=(0,u.useSearchAndFilters)(),t=(0,i.useOrderedClasses)(),n=(0,r.__useDispatch)(),l=(0,c.useFilters)(),[h,y]=a.useState(null),k=t.find(e=>e.id===h)?.label??"",[v,C]=useReorder(h,y,k??""),x=useFilteredCssClasses();if((0,a.useEffect)(()=>{const handler=e=>{if("z"===e.key&&(e.ctrlKey||e.metaKey)){if(e.stopImmediatePropagation(),e.preventDefault(),e.shiftKey)return void n(d.slice.actions.redo());n(d.slice.actions.undo())}};return window.addEventListener("keydown",handler,{capture:!0}),()=>window.removeEventListener("keydown",handler)},[n]),!t?.length)return a.createElement(EmptyState,null);const _=(0,b.getNotFoundType)(s,l,x);if(_)return a.createElement(b.NotFound,{notFoundType:_});const E=l?.length||s,w=x.length>1&&!E;return a.createElement(m.DeleteConfirmationProvider,null,a.createElement(o.List,{sx:{display:"flex",flexDirection:"column",gap:.5}},a.createElement(f.SortableProvider,{value:v,onChange:C,disableDragOverlay:!w},x?.map(({id:s,label:t})=>a.createElement(f.SortableItem,{key:s,id:s},({isDragged:r,isDragPlaceholder:o,triggerProps:l,triggerStyle:c})=>(r&&!h&&y(s),a.createElement(g.ClassItem,{id:s,label:t,renameClass:e=>{(0,p.trackGlobalClasses)({event:"classRenamed",classId:s,oldValue:t,newValue:e,source:"class-manager"}),n(d.slice.actions.update({style:{id:s,label:e}}))},selected:r,disabled:e||o,sortableTriggerProps:{...l,style:c},showSortIndicator:w})))))))},EmptyState=()=>a.createElement(o.Stack,{alignItems:"center",gap:1.5,pt:10,px:.5,maxWidth:"260px",margin:"auto"},a.createElement(h.FlippedColorSwatchIcon,{fontSize:"large"}),a.createElement(y,{variant:"subtitle2",component:"h2",color:"text.secondary"},(0,n.__)("There are no global classes yet.","elementor")),a.createElement(o.Typography,{align:"center",variant:"caption",color:"text.secondary"},(0,n.__)("CSS classes created in the editor panel will appear here. Once they are available, you can arrange their hierarchy, rename them, or delete them as needed.","elementor"))),y=(0,o.styled)(o.Typography)(({theme:e,variant:s})=>({"&.MuiTypography-root":{...e.typography[s]}})),useReorder=(e,s,t)=>{const a=(0,r.__useDispatch)();return[(0,l.useClassesOrder)(),r=>{a(d.slice.actions.setOrder(r)),e&&((0,p.trackGlobalClasses)({event:"classManagerReorder",classId:e,classTitle:t}),s(null))}]},useFilteredCssClasses=()=>{const e=(0,i.useOrderedClasses)(),{search:{debouncedValue:s}}=(0,u.useSearchAndFilters)(),t=(0,c.useFilters)(),r=(0,a.useMemo)(()=>e.map(e=>({...e,lowerLabel:e.label.toLowerCase()})),[e]),o=(0,a.useMemo)(()=>s.length>1?r.filter(e=>e.lowerLabel.includes(s.toLowerCase())):e,[s,e,r]);return(0,a.useMemo)(()=>t&&t.length>0?o.filter(e=>t.includes(e.id)):o,[o,t])}},"./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx":function(e,s,t){t.r(s),t.d(s,{NotFound:function(){return NotFound},NotFoundLayout:function(){return NotFoundLayout},getNotFoundType:function(){return getNotFoundType}});var a=t("react"),r=t("@elementor/icons"),o=t("@elementor/ui"),n=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const getNotFoundType=(e,s,t)=>{const a=t.length<=0&&e.length>1,r=s&&0===s.length;return a&&r?"filterAndSearch":a?"search":r?"filter":void 0},c={filterAndSearch:{mainText:(0,n.__)("Sorry, nothing matched.","elementor"),sceneryText:(0,n.__)("Try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},search:{mainText:(0,n.__)("Sorry, nothing matched","elementor"),sceneryText:(0,n.__)("Clear your input and try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},filter:{mainText:(0,n.__)("Sorry, nothing matched that search.","elementor"),sceneryText:(0,n.__)("Clear the filters and try something else.","elementor"),icon:a.createElement(r.ColorSwatchIcon,{color:"inherit",fontSize:"large"})}},NotFound=({notFoundType:e})=>{const{search:{onClearSearch:s,inputValue:t},filters:{onClearFilter:r}}=(0,l.useSearchAndFilters)();switch(e){case"filter":return a.createElement(NotFoundLayout,_extends({},c.filter,{onClear:r}));case"search":return a.createElement(NotFoundLayout,_extends({},c.search,{searchValue:t,onClear:s}));case"filterAndSearch":return a.createElement(NotFoundLayout,_extends({},c.filterAndSearch,{onClear:()=>{r(),s()}}))}},NotFoundLayout=({onClear:e,searchValue:s,mainText:t,sceneryText:r,icon:l})=>a.createElement(o.Stack,{color:"text.secondary",pt:5,alignItems:"center",gap:1,overflow:"hidden",justifySelf:"center"},l,a.createElement(o.Box,{sx:{width:"100%"}},a.createElement(o.Typography,{align:"center",variant:"subtitle2",color:"inherit"},t),s&&a.createElement(o.Typography,{variant:"subtitle2",color:"inherit",sx:{display:"flex",width:"100%",justifyContent:"center"}},a.createElement("span",null,"“"),a.createElement("span",{style:{maxWidth:"80%",overflow:"hidden",textOverflow:"ellipsis"}},s),a.createElement("span",null,"”."))),a.createElement(o.Typography,{align:"center",variant:"caption",color:"inherit"},r),a.createElement(o.Typography,{align:"center",variant:"caption",color:"inherit"},a.createElement(o.Link,{color:"secondary",variant:"caption",component:"button",onClick:e},(0,n.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts":function(e,s,t){function blockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.blockUserInteractions?.()}function unblockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.unblockUserInteractions?.()}t.r(s),t.d(s,{blockPanelInteractions:function(){return blockPanelInteractions},unblockPanelInteractions:function(){return unblockPanelInteractions}})},"./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx":function(e,s,t){t.r(s),t.d(s,{SortableItem:function(){return SortableItem},SortableProvider:function(){return SortableProvider},SortableTrigger:function(){return SortableTrigger}});var a=t("react"),r=t("@elementor/icons"),o=t("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const SortableProvider=e=>a.createElement(o.UnstableSortableProvider,_extends({restrictAxis:!0,variant:"static",dragPlaceholderStyle:{opacity:"1"}},e)),SortableTrigger=e=>a.createElement(n,_extends({},e,{role:"button",className:"class-item-sortable-trigger","aria-label":"sort"}),a.createElement(r.GripVerticalIcon,{fontSize:"tiny"})),SortableItem=({children:e,id:s,...t})=>a.createElement(o.UnstableSortableItem,_extends({},t,{id:s,render:({itemProps:s,isDragged:t,triggerProps:r,itemStyle:n,triggerStyle:c,dropIndicationStyle:i,showDropIndication:d,isDragOverlay:p,isDragPlaceholder:u})=>a.createElement(o.Box,_extends({},s,{style:n,component:"li",role:"listitem",sx:{backgroundColor:p?"background.paper":void 0}}),e({itemProps:s,isDragged:t,triggerProps:r,itemStyle:n,triggerStyle:c,isDragPlaceholder:u}),d&&a.createElement(l,{style:i}))})),n=(0,o.styled)("div")(({theme:e})=>({position:"absolute",left:0,top:"50%",transform:`translate( -${e.spacing(1.5)}, -50% )`,color:e.palette.action.active})),l=(0,o.styled)(o.Box)`
	width: 100%;
	height: 1px;
	background-color: ${({theme:e})=>e.palette.text.primary};
`},"./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx":function(e,s,t){t.r(s),t.d(s,{ConvertLocalClassToGlobalClass:function(){return ConvertLocalClassToGlobalClass}});var a=t("react"),r=t("@elementor/editor-styles-repository"),o=t("@elementor/editor-ui"),n=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),i=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts");const ConvertLocalClassToGlobalClass=e=>{const s=e.styleDef;return a.createElement(a.Fragment,null,a.createElement(o.MenuListItem,{disabled:!e.canConvert,onClick:()=>{const t=function createClassName(e){let s=1,t=`${e}${s}`;for(;!(0,r.validateStyleLabel)(t,"create").isValid;)t=`${e}${++s}`;return t}("converted-class-");if(!s)throw new Error("Style definition is required for converting local class to global class.");const a=c.globalClassesStylesProvider.actions.create?.(t,s.variants);a&&(e.successCallback(a),(0,i.trackGlobalClasses)({classId:a,event:"classCreated",source:"converted",classTitle:t}))},dense:!0,sx:{"&.Mui-focusVisible":{border:"none",boxShadow:"none !important",backgroundColor:"transparent"}}},(0,l.__)("Convert to global class","elementor")),a.createElement(n.Divider,null))}},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx":function(e,s,t){t.r(s),t.d(s,{CssClassUsagePopover:function(){return CssClassUsagePopover}});var a=t("react"),r=t("@elementor/editor-documents"),o=t("@elementor/editor-ui"),n=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),d=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts");const p={"wp-post":{label:(0,c.__)("Post","elementor"),icon:a.createElement(n.PostTypeIcon,{fontSize:"inherit"})},"wp-page":{label:(0,c.__)("Page","elementor"),icon:a.createElement(n.PagesIcon,{fontSize:"inherit"})},popup:{label:(0,c.__)("Popup","elementor"),icon:a.createElement(n.PopupTemplateIcon,{fontSize:"inherit"})},header:{label:(0,c.__)("Header","elementor"),icon:a.createElement(n.HeaderTemplateIcon,{fontSize:"inherit"})},footer:{label:(0,c.__)("Footer","elementor"),icon:a.createElement(n.FooterTemplateIcon,{fontSize:"inherit"})}},CssClassUsagePopover=({cssClassID:e,onClose:s})=>{const{data:t}=(0,i.useCssClassUsageByID)(e),g=(0,r.__useOpenDocumentInNewTab)(),m=t?.content.map(({title:e,elements:s,pageId:t,type:a})=>({type:"item",value:t,label:e,secondaryText:s.length.toString(),docType:a}))??[];return a.createElement(a.Fragment,null,a.createElement(o.PopoverHeader,{icon:a.createElement(n.CurrentLocationIcon,{fontSize:"tiny"}),title:a.createElement(l.Stack,{flexDirection:"row",gap:1,alignItems:"center"},a.createElement(l.Box,{"aria-label":"header-title"},(0,c.__)("Locator","elementor")),a.createElement(l.Box,null,a.createElement(l.Chip,{sx:{lineHeight:1},size:"tiny",label:t.total}))),onClose:s}),a.createElement(l.Divider,null),a.createElement(o.PopoverBody,{width:300},a.createElement(o.PopoverMenuList,{onSelect:s=>{g(+s),(0,d.trackGlobalClasses)({event:"classUsageLocate",classId:e})},items:m,onClose:()=>{},menuListTemplate:u,menuItemContentTemplate:e=>a.createElement(l.Stack,{flexDirection:"row",flex:1,alignItems:"center"},a.createElement(l.Box,{display:"flex",sx:{pr:1}},a.createElement(l.Tooltip,{disableInteractive:!0,title:p?.[e.docType]?.label??e.docType,placement:"top"},a.createElement(l.Icon,{fontSize:"small"},p?.[e.docType]?.icon||a.createElement(n.PagesIcon,{fontSize:"inherit"})))),a.createElement(l.Box,{sx:{pr:.5,maxWidth:"173px"},display:"flex"},a.createElement(o.EllipsisWithTooltip,{title:e.label,as:l.Typography,variant:"caption",maxWidth:"173px",sx:{lineHeight:1}})),a.createElement(n.ExternalLinkIcon,{className:"hover-only-icon",fontSize:"tiny"}),a.createElement(l.Chip,{sx:{ml:"auto"},size:"tiny",label:e.secondaryText}))})))},u=(0,l.styled)(l.MenuList)(({theme:e})=>({"& > li":{display:"flex",cursor:"pointer",height:32,width:"100%"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),textOverflow:"ellipsis",position:"absolute",top:0,left:0,opacity:1,".hover-only-icon":{color:e.palette.text.disabled,opacity:0},"&:hover":{borderRadius:e.spacing(.5),backgroundColor:e.palette.action.hover,".hover-only-icon":{color:e.palette.text.disabled,opacity:1}}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx":function(e,s,t){t.r(s),t.d(s,{CssClassUsageTrigger:function(){return CssClassUsageTrigger}});var a=t("react"),r=t("@elementor/editor-ui"),o=t("@elementor/icons"),n=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),i=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),d=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const CssClassUsageTrigger=({id:e,onClick:s})=>{const{data:{total:t},isLoading:r}=(0,c.useCssClassUsageByID)(e),l=(0,n.usePopupState)({variant:"popover",popupId:"css-class-usage-popover"});if(r)return null;const u=0!==t?TooltipWrapper:InfoAlertMessage;return a.createElement(a.Fragment,null,a.createElement(n.Box,{position:"relative",onMouseEnter:()=>{(0,i.trackGlobalClasses)({event:"classUsageHovered",classId:e,usage:t})}},a.createElement(u,{total:t},a.createElement(p,_extends({disabled:0===t,size:"tiny"},(0,n.bindTrigger)(l),{onClick:a=>{0!==t&&((0,n.bindTrigger)(l).onClick(a),s(e),(0,i.trackGlobalClasses)({event:"classUsageClicked",classId:e}))}}),a.createElement(o.CurrentLocationIcon,{fontSize:"tiny"})))),a.createElement(n.Box,null,a.createElement(n.Popover,_extends({anchorOrigin:{vertical:"center",horizontal:"right"},transformOrigin:{vertical:15,horizontal:-50}},(0,n.bindPopover)(l),{onClose:()=>{(0,n.bindPopover)(l).onClose(),s("")}}),a.createElement(d.CssClassUsagePopover,{onClose:l.close,"aria-label":"css-class-usage-popover",cssClassID:e}))))},p=(0,n.styled)(n.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}},height:"22px",width:"22px"})),TooltipWrapper=({children:e,total:s})=>a.createElement(n.Tooltip,{disableInteractive:!0,placement:"top",title:`${(0,l.__)("Show {{number}} {{locations}}","elementor").replace("{{number}}",s.toString()).replace("{{locations}}",1===s?(0,l.__)("location","elementor"):(0,l.__)("locations","elementor"))}`},a.createElement("span",null,e)),InfoAlertMessage=({children:e})=>a.createElement(n.Infotip,{disableInteractive:!0,placement:"top",color:"secondary",content:a.createElement(r.InfoAlert,{sx:{mt:1}},(0,l.__)("This class isn’t being used yet.","elementor"))},a.createElement("span",null,e))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts":function(e,s,t){t.r(s),t.d(s,{CssClassUsagePopover:function(){return a.CssClassUsagePopover},CssClassUsageTrigger:function(){return r.CssClassUsageTrigger}});var a=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx"),r=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx")},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts":function(e,s,t){t.r(s),t.d(s,{QUERY_KEY:function(){return a}});const a="css-classes-usage"},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts":function(e,s,t){t.r(s),t.d(s,{transformData:function(){return transformData}});const transformData=e=>Object.entries(e).reduce((e,[s,t])=>(e[s]={content:t||[],total:t.reduce((e,s)=>e+(s?.total||0),0)},e),{})},"./packages/packages/core/editor-global-classes/src/components/populate-store.tsx":function(e,s,t){t.r(s),t.d(s,{PopulateStore:function(){return PopulateStore}});var a=t("react"),r=t("@elementor/store"),o=t("./packages/packages/core/editor-global-classes/src/api.ts"),n=t("./packages/packages/core/editor-global-classes/src/store.ts");function PopulateStore(){const e=(0,r.__useDispatch)();return(0,a.useEffect)(()=>{Promise.all([o.apiClient.all("preview"),o.apiClient.all("frontend")]).then(([s,t])=>{const{data:a}=s,{data:r}=t;e(n.slice.actions.load({preview:{items:a.data,order:a.meta.order},frontend:{items:r.data,order:r.meta.order}}))})},[e]),null}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx":function(e,s,t){t.r(s),t.d(s,{ActiveFilters:function(){return ActiveFilters}});var a=t("react"),r=t("@elementor/ui"),o=t("@wordpress/i18n"),n=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),l=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),c=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),i=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");const ActiveFilters=()=>{const{filters:{filters:e,setFilters:s}}=(0,l.useSearchAndFilters)(),t=Object.keys(e).filter(s=>e[s]),p=t.length>0;return a.createElement(r.Stack,{direction:"row",alignItems:"center",justifyContent:"space-between"},a.createElement(r.Stack,{direction:"row",gap:.5,alignItems:"center",flexWrap:"wrap"},t.map(e=>a.createElement(r.Chip,{key:e,label:i.filterConfig[e],onDelete:()=>(e=>{s(s=>({...s,[e]:!1})),(0,n.trackGlobalClasses)({event:"classManagerFilterUsed",action:"remove",type:e,trigger:"header"})})(e),sx:d,size:"tiny"}))),p&&a.createElement(c.ClearIconButton,{trigger:"header",tooltipText:(0,o.__)("Clear Filters","elementor"),sx:{margin:"0 0 auto auto"}}))},d={"& .MuiChip-deleteIcon":{display:"none",transition:"opacity 0.2s"},"&:hover .MuiChip-deleteIcon":{display:"block"}}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx":function(e,s,t){t.r(s),t.d(s,{ClearIconButton:function(){return ClearIconButton}});var a=t("react"),r=t("@elementor/icons"),o=t("@elementor/ui"),n=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),l=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClearIconButton=({tooltipText:e,sx:s,trigger:t})=>{const{filters:{onClearFilter:i}}=(0,l.useSearchAndFilters)();return a.createElement(o.Tooltip,{title:e,placement:"top",disableInteractive:!0},a.createElement(o.Box,null,a.createElement(c,{"aria-label":e,size:"tiny",onClick:()=>{i(t),(0,n.trackGlobalClasses)({event:"classManagerFilterCleared",trigger:t})},sx:s},a.createElement(r.BrushBigIcon,{fontSize:"tiny"}))))},c=(0,o.styled)(o.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}}}))},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx":function(e,s,t){t.r(s),t.d(s,{CssClassFilter:function(){return CssClassFilter}});var a=t("react"),r=t("@elementor/editor-ui"),o=t("@elementor/icons"),n=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),i=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),d=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),p=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var s=1;s<arguments.length;s++){var t=arguments[s];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const CssClassFilter=()=>{const{filters:{filters:e}}=(0,i.useSearchAndFilters)(),s=(0,n.usePopupState)({variant:"popover",disableAutoFocus:!0});a.useEffect(()=>{s.isOpen&&(0,c.trackGlobalClasses)({event:"classManagerFiltersOpened"})},[s.isOpen]);const t=Object.values(e).some(e=>e);return a.createElement(a.Fragment,null,a.createElement(n.Tooltip,{title:(0,l.__)("Filters","elementor"),placement:"top"},a.createElement(n.ToggleButton,_extends({value:"filter",size:"tiny",selected:s.isOpen},(0,n.bindToggle)(s)),a.createElement(o.FilterIcon,{fontSize:"tiny"}))),a.createElement(n.Popover,_extends({sx:{maxWidth:"344px"},anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-21}},(0,n.bindPopover)(s)),a.createElement(r.PopoverHeader,{actions:t?[a.createElement(d.ClearIconButton,{trigger:"menu",key:"clear-all-button",tooltipText:(0,l.__)("Clear all","elementor")})]:[],onClose:s.close,title:(0,l.__)("Filters","elementor"),icon:a.createElement(o.FilterIcon,{fontSize:"tiny"})}),a.createElement(n.Divider,{sx:{borderWidth:"1px 0 0 0"}}),a.createElement(r.PopoverBody,{width:344,height:125},a.createElement(p.FilterList,null))))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx":function(e,s,t){t.r(s),t.d(s,{FilterList:function(){return FilterList},filterConfig:function(){return i}});var a=t("react"),r=t("@elementor/ui"),o=t("@wordpress/i18n"),n=t("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx"),l=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),c=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const i={unused:(0,o.__)("Unused","elementor"),empty:(0,o.__)("Empty","elementor"),onThisPage:(0,o.__)("On this page","elementor")},FilterList=()=>{const{filters:{filters:e,setFilters:s}}=(0,c.useSearchAndFilters)(),t=(0,n.useFilteredCssClassUsage)(),handleOnClick=t=>{s(e=>({...e,[t]:!e[t]})),(0,l.trackGlobalClasses)({event:"classManagerFilterUsed",action:e[t]?"remove":"apply",type:t,trigger:"menu"})};return a.createElement(r.MenuList,null,a.createElement(r.MenuItem,{onClick:()=>handleOnClick("unused")},a.createElement(LabeledCheckbox,{label:i.unused,checked:e.unused,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:t.unused.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("empty")},a.createElement(LabeledCheckbox,{label:i.empty,checked:e.empty,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:t.empty.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("onThisPage")},a.createElement(LabeledCheckbox,{label:i.onThisPage,checked:e.onThisPage,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:t.onThisPage.length})})))},LabeledCheckbox=({label:e,suffix:s,checked:t})=>a.createElement(r.Stack,{direction:"row",alignItems:"center",gap:.5,flex:1},a.createElement(r.Checkbox,{size:"small",checked:t,sx:{padding:0,color:"text.tertiary","&.Mui-checked":{color:"text.tertiary"}}}),a.createElement(r.Typography,{variant:"caption",sx:{color:"text.secondary"}},e),s)},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx":function(e,s,t){t.r(s),t.d(s,{ClassManagerSearch:function(){return ClassManagerSearch}});var a=t("react"),r=t("@elementor/icons"),o=t("@elementor/ui"),n=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts"),c=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClassManagerSearch=()=>{const{search:{inputValue:e,handleChange:s}}=(0,c.useSearchAndFilters)();return a.createElement(o.Stack,{direction:"row",gap:.5,sx:{width:"100%"}},a.createElement(o.Box,{sx:{flexGrow:1}},a.createElement(o.TextField,{role:"search",fullWidth:!0,size:"tiny",value:e,onFocus:()=>{(0,l.trackGlobalClasses)({event:"classManagerSearched"})},placeholder:(0,n.__)("Search","elementor"),onChange:e=>s(e.target.value),InputProps:{startAdornment:a.createElement(o.InputAdornment,{position:"start"},a.createElement(r.SearchIcon,{fontSize:"tiny"}))}})))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx":function(e,s,t){t.r(s),t.d(s,{SearchAndFilterProvider:function(){return SearchAndFilterProvider},useSearchAndFilters:function(){return useSearchAndFilters}});var a=t("react"),r=t("@elementor/utils");const o=(0,a.createContext)(void 0),n={empty:!1,onThisPage:!1,unused:!1},SearchAndFilterProvider=({children:e})=>{const[s,t]=a.useState(n),{debouncedValue:l,inputValue:c,handleChange:i}=(0,r.useDebounceState)({delay:300,initialValue:(()=>{const e=localStorage.getItem("elementor-global-classes-search");return e?(localStorage.removeItem("elementor-global-classes-search"),e):""})()});return a.createElement(o.Provider,{value:{search:{debouncedValue:l,inputValue:c,handleChange:i,onClearSearch:()=>{i("")}},filters:{filters:s,setFilters:t,onClearFilter:()=>{t(n)}}}},e)},useSearchAndFilters=()=>{const e=(0,a.useContext)(o);if(!e)throw new Error("useSearchContext must be used within a SearchContextProvider");return e}},"./packages/packages/core/editor-global-classes/src/errors.ts":function(e,s,t){t.r(s),t.d(s,{GlobalClassLabelAlreadyExistsError:function(){return o},GlobalClassNotFoundError:function(){return r},GlobalClassTrackingError:function(){return n}});var a=t("@elementor/utils");const r=(0,a.createError)({code:"global_class_not_found",message:"Global class not found."}),o=(0,a.createError)({code:"global_class_label_already_exists",message:"Class with this name already exists."}),n=(0,a.createError)({code:"global_class_tracking_error",message:"Error tracking global classes event."})},"./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts":function(e,s,t){t.r(s),t.d(s,{GLOBAL_CLASSES_PROVIDER_KEY:function(){return p},globalClassesStylesProvider:function(){return u}});var a=t("@elementor/editor-styles"),r=t("@elementor/editor-styles-repository"),o=t("@elementor/store"),n=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=t("./packages/packages/core/editor-global-classes/src/errors.ts"),i=t("./packages/packages/core/editor-global-classes/src/store.ts"),d=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts");const p="global-classes",u=(0,r.createStylesProvider)({key:p,priority:30,limit:100,labels:{singular:(0,n.__)("class","elementor"),plural:(0,n.__)("classes","elementor")},subscribe:e=>subscribeWithStates(e),capabilities:(0,l.getCapabilities)(),actions:{all:()=>{const e=(0,i.selectOrderedClasses)((0,o.__getState)());return localStorage.setItem("elementor-global-classes",JSON.stringify(e)),e},get:e=>(0,i.selectClass)((0,o.__getState)(),e),resolveCssName:e=>(0,i.selectClass)((0,o.__getState)(),e)?.label??e,create:(e,s=[])=>{const t=(0,i.selectGlobalClasses)((0,o.__getState)());if(Object.values(t).map(e=>e.label).includes(e))throw new c.GlobalClassLabelAlreadyExistsError({context:{label:e}});const r=Object.keys(t),n=(0,a.generateId)("g-",r);return(0,o.__dispatch)(i.slice.actions.add({id:n,type:"class",label:e,variants:s})),n},update:e=>{(0,o.__dispatch)(i.slice.actions.update({style:e}))},delete:e=>{(0,o.__dispatch)(i.slice.actions.delete(e))},updateProps:e=>{(0,o.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,props:e.props}))},updateCustomCss:e=>{(0,o.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,custom_css:e.custom_css,props:{}}))},tracking:e=>{(0,d.trackGlobalClasses)(e).catch(e=>{throw new c.GlobalClassTrackingError({cause:e})})}}}),subscribeWithStates=e=>{let s=(0,i.selectData)((0,o.__getState)());return(0,o.__subscribeWithSelector)(e=>e.globalClasses,t=>{e(s.items,t.data.items),s=t.data})}},"./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts":function(e,s,t){t.r(s),t.d(s,{useClassesOrder:function(){return useClassesOrder}});var a=t("@elementor/store"),r=t("./packages/packages/core/editor-global-classes/src/store.ts");const useClassesOrder=()=>(0,a.__useSelector)(r.selectOrder)},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts":function(e,s,t){t.r(s),t.d(s,{useCssClassUsageByID:function(){return useCssClassUsageByID}});var a=t("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts");const r={total:0,content:[]},useCssClassUsageByID=e=>{const{data:s,...t}=(0,a.useCssClassUsage)();return{...t,data:s?.[e]??r}}},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts":function(e,s,t){t.r(s),t.d(s,{useCssClassUsage:function(){return useCssClassUsage}});var a=t("@elementor/query"),r=t("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),o=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");const useCssClassUsage=()=>(0,a.useQuery)({queryKey:[o.QUERY_KEY],queryFn:r.fetchCssClassUsage,refetchOnMount:!1,refetchOnWindowFocus:!0})},"./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts":function(e,s,t){t.r(s),t.d(s,{useDirtyState:function(){return useDirtyState}});var a=t("@elementor/store"),r=t("./packages/packages/core/editor-global-classes/src/store.ts");const useDirtyState=()=>(0,a.__useSelector)(r.selectIsDirty)},"./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts":function(e,s,t){t.r(s),t.d(s,{useAllCssClassesIDs:function(){return useAllCssClassesIDs},useEmptyCssClass:function(){return useEmptyCssClass}});var a=t("@elementor/store"),r=t("./packages/packages/core/editor-global-classes/src/store.ts");const useEmptyCssClass=()=>(0,a.__useSelector)(r.selectEmptyCssClass),useAllCssClassesIDs=()=>{const e=(0,a.__useSelector)(r.selectGlobalClasses);return Object.keys(e)}},"./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx":function(e,s,t){t.r(s),t.d(s,{useFilteredCssClassUsage:function(){return useFilteredCssClassUsage}});var a=t("react"),r=t("@elementor/editor-documents"),o=t("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts"),n=t("./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts");const l={empty:[],onThisPage:[],unused:[]},useFilteredCssClassUsage=()=>{const e=(0,r.__useActiveDocument)(),s=(0,n.useEmptyCssClass)(),{data:t,isLoading:c}=(0,o.useCssClassUsage)(),i=(0,n.useAllCssClassesIDs)(),d=(0,a.useMemo)(()=>s.map(({id:e})=>e),[s]),p=(0,a.useMemo)(()=>t&&e?((e,s)=>{const t=[];for(const a in e)e[a].content.forEach(e=>{+e.pageId===s&&t.push(a)});return t})(t,e.id):[],[t,e]),u=(0,a.useMemo)(()=>t?((e,s)=>{const t=new Set(e);return s.filter(e=>!t.has(e))})(Object.keys(t),i):[],[t,i]);return!c&&t&&e?{onThisPage:p,unused:u,empty:d}:l}},"./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts":function(e,s,t){t.r(s),t.d(s,{useFilters:function(){return useFilters}});var a=t("react"),r=t("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),o=t("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx");const useFilters=()=>{const{filters:{filters:e}}=(0,r.useSearchAndFilters)(),s=(0,o.useFilteredCssClassUsage)();return(0,a.useMemo)(()=>{const t=Object.entries(e).filter(([,e])=>e);return 0===t.length?null:t.reduce((e,[t],a)=>{const r=s[t]||[];return 0===a?r:e.filter(e=>r.includes(e))},[])},[e,s])}},"./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts":function(e,s,t){t.r(s),t.d(s,{useOrderedClasses:function(){return useOrderedClasses}});var a=t("@elementor/store"),r=t("./packages/packages/core/editor-global-classes/src/store.ts");const useOrderedClasses=()=>(0,a.__useSelector)(r.selectOrderedClasses)},"./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts":function(e,s,t){t.r(s),t.d(s,{PrefetchCssClassUsage:function(){return PrefetchCssClassUsage},usePrefetchCssClassUsage:function(){return usePrefetchCssClassUsage}});var a=t("@elementor/query"),r=t("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),o=t("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");function usePrefetchCssClassUsage(){const e=(0,a.useQueryClient)();return{prefetchClassesUsage:()=>e.prefetchQuery({queryKey:[o.QUERY_KEY],queryFn:r.fetchCssClassUsage})}}const PrefetchCssClassUsage=()=>{const{prefetchClassesUsage:e}=usePrefetchCssClassUsage();return e(),null}},"./packages/packages/core/editor-global-classes/src/init.ts":function(e,s,t){t.r(s),t.d(s,{init:function(){return init}});var a=t("@elementor/editor"),r=t("@elementor/editor-editing-panel"),o=t("@elementor/editor-panels"),n=t("@elementor/editor-styles-repository"),l=t("@elementor/store"),c=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx"),i=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),d=t("./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx"),p=t("./packages/packages/core/editor-global-classes/src/components/populate-store.tsx"),u=t("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),g=t("./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts"),m=t("./packages/packages/core/editor-global-classes/src/mcp-integration/index.ts"),h=t("./packages/packages/core/editor-global-classes/src/store.ts"),b=t("./packages/packages/core/editor-global-classes/src/sync-with-document.tsx");function init(){(0,l.__registerSlice)(h.slice),(0,o.__registerPanel)(i.panel),n.stylesRepository.register(u.globalClassesStylesProvider),(0,a.injectIntoLogic)({id:"global-classes-populate-store",component:p.PopulateStore}),(0,a.injectIntoLogic)({id:"global-classes-sync-with-document",component:b.SyncWithDocumentSave}),(0,a.injectIntoLogic)({id:"global-classes-prefetch-css-class-usage",component:g.PrefetchCssClassUsage}),(0,r.injectIntoCssClassConvert)({id:"global-classes-convert-from-local-class",component:d.ConvertLocalClassToGlobalClass}),(0,r.injectIntoClassSelectorActions)({id:"global-classes-manager-button",component:c.ClassManagerButton}),(0,r.registerStyleProviderToColors)(u.GLOBAL_CLASSES_PROVIDER_KEY,{name:"global",getThemeColor:e=>e.palette.global.dark}),(0,m.initMcpIntegration)()}},"./packages/packages/core/editor-global-classes/src/mcp-integration/classes-resource.ts":function(e,s,t){t.r(s),t.d(s,{GLOBAL_CLASSES_URI:function(){return o},initClassesResource:function(){return initClassesResource}});var a=t("@elementor/editor-mcp"),r=t("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts");const o="elementor://global-classes",initClassesResource=()=>{[(0,a.getMCPByDomain)("canvas"),(0,a.getMCPByDomain)("classes")].forEach(e=>{const{mcpServer:s,resource:t,waitForReady:a}=e;t("global-classes",o,{description:"Global classes list."},async()=>({contents:[{uri:o,text:localStorage["elementor-global-classes"]??"{}"}]})),a().then(()=>{r.globalClassesStylesProvider.subscribe(()=>{s.sendResourceListChanged()})})})}},"./packages/packages/core/editor-global-classes/src/mcp-integration/index.ts":function(e,s,t){t.r(s),t.d(s,{initMcpIntegration:function(){return initMcpIntegration}});var a=t("@elementor/editor-mcp"),r=t("./packages/packages/core/editor-global-classes/src/mcp-integration/classes-resource.ts"),o=t("./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-apply-unapply-global-classes.ts"),n=t("./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-get-global-class-usages.ts"),l=t("./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-manage-global-classes.ts");const initMcpIntegration=()=>{const e=(0,a.getMCPByDomain)("classes",{instructions:"MCP server for management of Elementor global classes"});(0,o.default)(e),(0,n.default)(e),(0,l.initManageGlobalClasses)(e),(0,r.initClassesResource)()}},"./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-apply-unapply-global-classes.ts":function(e,s,t){t.r(s),t.d(s,{default:function(){return initMcpApplyUnapplyGlobalClasses}});var a=t("@elementor/editor-editing-panel"),r=t("@elementor/schema");function initMcpApplyUnapplyGlobalClasses(e){e.addTool({schema:{classId:r.z.string().describe("The ID of the class to apply"),elementId:r.z.string().describe("The ID of the element to which the class will be applied")},outputSchema:{result:r.z.string().describe("Result message indicating the success of the apply operation")},name:"apply-global-class",modelPreferences:{intelligencePriority:.7,speedPriority:.8},description:'Apply a global class to an element, enabling consistent styling through your design system.\n\n## When to use this tool:\n**ALWAYS use this IMMEDIATELY AFTER building compositions** to apply the global classes you created beforehand:\n- After using "build-compositions" tool, apply semantic classes to the created elements\n- When applying consistent typography styles (heading-primary, text-body, etc.)\n- When applying theme colors or brand styles (bg-brand, button-cta, etc.)\n- When ensuring spacing consistency (spacing-section-large, etc.)\n\n**DO NOT use this tool** for:\n- Elements that don\'t share styles with other elements (use inline styles instead)\n- Layout-specific properties (those should remain inline in stylesConfig)\n\n## Prerequisites:\n- **REQUIRED**: Get the list of available global classes from \'elementor://global-classes\' resource\n- **REQUIRED**: Get element IDs from the composition XML returned by "build-compositions" tool\n- Ensure you have the most up-to-date list of classes applied to the element to avoid duplicates\n- Make sure you have the correct class ID that you want to apply\n\n## Best Practices:\n1. Apply multiple classes to a single element if needed (typography + color + spacing)\n2. After applying, the tool will remind you to remove duplicate inline styles from elementConfig\n3. Classes should describe purpose, not implementation (e.g., "heading-primary" not "big-red-text")',handler:async e=>{const{classId:s,elementId:t}=e,r=(0,a.doGetAppliedClasses)(t);return(0,a.doApplyClasses)(t,[...r,s]),{llm_instructions:"Please check the element-configuration, find DUPLICATES in the style schema that are in the class, and remove them",result:`Class ${s} applied to element ${t} successfully.`}}}),e.addTool({name:"unapply-global-class",schema:{classId:r.z.string().describe("The ID of the class to unapply"),elementId:r.z.string().describe("The ID of the element from which the class will be unapplied")},outputSchema:{result:r.z.string().describe("Result message indicating the success of the unapply operation")},modelPreferences:{intelligencePriority:.7,speedPriority:.8},description:"Unapply a (global) class from the current element\n\n## When to use this tool:\n- When a user requests to unapply a global class or a class from an element in the Elementor editor.\n- When you need to remove a specific class from an element's applied classes.\n\n## Prerequisites:\n- Ensure you have the most up-to-date list of classes applied to the element to avoid errors.\n  The list is available at always up-to-date resource 'elementor://global-classes'.\n- Make sure you have the correct class ID that you want to unapply.\n\n<note>\nIf the user want to unapply a class by it's name and not ID, retreive the id from the list, available at uri elementor://global-classes\n</note>\n",handler:async e=>{const{classId:s,elementId:t}=e;if(!(0,a.doUnapplyClass)(t,s))throw new Error(`Class ${s} is not applied to element ${t}, cannot unapply it.`);return{result:`Class ${s} unapplied from element ${t} successfully.`}}})}},"./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-get-global-class-usages.ts":function(e,s,t){t.r(s),t.d(s,{default:function(){return initMcpApplyGetGlobalClassUsages}});var a=t("@elementor/schema"),r=t("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts");function initMcpApplyGetGlobalClassUsages(e){const{addTool:s}=e;s({name:"get-global-class-usages",modelPreferences:{intelligencePriority:.6,speedPriority:.8},description:"Retreive the usages of global-classes ACCROSS PAGES designed by Elementor editor.\n\n## Prequisites: CRITICAL\n- The list of global classes and their applid values is available at resource uri elementor://global-classes\n\n## When to use this tool:\n- When a user requests to see where a specific global class is being used accross the site.\n- When you need to manage or clean up unused global classes.\n- Before deleting a global class, to ensure it is not in use in any other pages.\n\n## When NOT to use this tool:\n- For getting the list of global classes, refer to the resource at uri elementor://global-classes\n",outputSchema:{usages:a.z.array(a.z.object({classId:a.z.string().describe('The ID of the class, not visible to the user. To retreive the name of the class, use the "list-global-classes" tool'),usages:a.z.array(a.z.object({pageId:a.z.string().describe("The ID of the page where the class is used"),title:a.z.string().describe("The title of the page where the class is used"),total:a.z.number().describe("The number of times the class is used on this page"),elements:a.z.array(a.z.string()).describe("List of element IDs using this class on the page")}))}))},handler:async()=>{const e=await(0,r.fetchCssClassUsage)(),s={usages:[]};return Object.entries(e).forEach(([e,t])=>{const a={classId:e,usages:[]};if("number"!=typeof t){const{content:e}=t;e.forEach(e=>{a.usages.push({pageId:String(e.pageId),title:e.title,total:e.total,elements:e.elements})}),s.usages.push(a)}}),s}})}},"./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-manage-global-classes.ts":function(e,s,t){t.r(s),t.d(s,{initManageGlobalClasses:function(){return initManageGlobalClasses}});var a=t("@elementor/editor-canvas"),r=t("@elementor/editor-props"),o=t("@elementor/editor-styles"),n=t("@elementor/schema"),l=t("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),c=t("./packages/packages/core/editor-global-classes/src/save-global-classes.tsx"),i=t("./packages/packages/core/editor-global-classes/src/mcp-integration/classes-resource.ts");const d={action:n.z.enum(["create","modify","delete"]).describe("Operation to perform"),classId:n.z.string().optional().describe("Global class ID (required for modify). Get from elementor://global-classes resource."),globalClassName:n.z.string().optional().describe("Global class name (required for create)"),props:n.z.record(n.z.any()).describe('key-value of style-schema PropValues. Available properties at dynamic resource "elementor://styles/schema/{property-name}"'),breakpoint:n.z.nullable(n.z.string().describe("Responsive breakpoint name for styles. Defaults to desktop (null).")).default(null).describe("Responsive breakpoint name for styles. Defaults to desktop (null).")},p={status:n.z.enum(["ok","error"]).describe("Operation status"),classId:n.z.string().optional().describe("Class ID (returned on create success)"),message:n.z.string().optional().describe("Error details if status is error")},handler=async e=>{const{action:s,classId:t,globalClassName:a,props:n,breakpoint:i}=e;if("create"===s&&!a)return{status:"error",message:"Create requires globalClassName"};if("modify"===s&&!t)return{status:"error",message:"Modify requires classId"};if("delete"===s&&!t)return{status:"error",message:"Delete requires classId"};const{create:d,update:p,delete:u}=l.globalClassesStylesProvider.actions;if(!d||!p||!u)return{status:"error",message:"Required actions not available"};const g=[],m=(0,o.getStylesSchema)(),h=Object.keys(m);if(Object.keys(n).forEach(e=>{const s=m[e];if(!s)return void g.push(`Property "${e}" does not exist in styles schema.`);const{valid:t,jsonSchema:a}=r.Schema.validatePropValue(s,n[e]);t||g.push(`- Property "${e}" has invalid value\n  Expected schema: ${a}\n`)}),g.length>0)return{status:"error",message:`Validation errors:\n${g.join("\n")}\nAvailable Properties: ${h.join(", ")}\nUpdate your input and try again.`};const b=window.elementorV2.editorVariables.Utils;Object.keys(n).forEach(e=>{n[e]=r.Schema.adjustLlmPropValueSchema(n[e],{transformers:b.globalVariablesLLMResolvers})});const f=i??"desktop";try{switch(s){case"create":const e=await async function attemptCreate(e){const{props:s,breakpoint:t,className:a,stylesProvider:r}=e,{create:o,delete:n}=r.actions;if(!a)throw new Error("Global class name is a required for creation");if(!o||!n)throw new Error("User is unable to create global classes");const l=o(a,[{meta:{breakpoint:t,state:null},custom_css:null,props:s}]);try{return await(0,c.saveGlobalClasses)({context:"frontend"}),l}catch{return n(l),null}}({props:n,className:a,stylesProvider:l.globalClassesStylesProvider,breakpoint:f});return e?{status:"ok",message:`created global class with ID ${e}`}:{status:"error",message:"error creating class"};case"modify":const s=await async function attemptUpdate(e){const{props:s,breakpoint:t,classId:a,stylesProvider:r}=e,{updateProps:o,update:n}=r.actions;if(!a)throw new Error("Class ID is required for modification");if(!o||!n)throw new Error("User is unable to update global classes");const l=structuredClone(r.actions.all());try{return o({id:a,props:s,meta:{breakpoint:t,state:null}}),await(0,c.saveGlobalClasses)({context:"frontend"}),!0}catch{return l.forEach(e=>{n({id:e.id,variants:e.variants})}),await(0,c.saveGlobalClasses)({context:"frontend"}),!1}}({classId:t,props:n,stylesProvider:l.globalClassesStylesProvider,breakpoint:f});return s?{status:"ok",classId:t}:{status:"error",message:"error modifying class"};case"delete":const r=await async function attemptDelete(e){const{classId:s,stylesProvider:t}=e,{delete:a,create:r}=t.actions;if(!s)throw new Error("Class ID is required for deletion");if(!a||!r)throw new Error("User is unable to delete global classes");const o=structuredClone(t.actions.all()).find(e=>e.id===s);if(!o)throw new Error(`Class with ID "${s}" not found`);try{return a(s),await(0,c.saveGlobalClasses)({context:"frontend"}),!0}catch{return!1}}({classId:t,stylesProvider:l.globalClassesStylesProvider});return r?{status:"ok",message:`deleted global class with ID ${t}`}:{status:"error",message:"error deleting class"}}}catch(e){return{status:"error",message:`${s} failed: ${e.message||"Unknown error"}`}}},initManageGlobalClasses=e=>{const{addTool:s}=e;s({name:"manage-global-classes",requiredResources:[{uri:i.GLOBAL_CLASSES_URI,description:"Global classes list"},{uri:a.STYLE_SCHEMA_URI,description:"Style schema resources"},{uri:a.BREAKPOINTS_SCHEMA_URI,description:"Breakpoints list"}],modelPreferences:{intelligencePriority:.85,speedPriority:.6},description:"Manages global classes (create/modify) in Elementor editor. Check [elementor://global-classes] and style schemas first.\n\nCREATE: Requires globalClassName, props. Use semantic naming (heading-primary, button-cta, text-muted). Check existing classes to avoid duplicates. ALWAYS create global classes BEFORE compositions for reusable styles.\nMODIFY: Requires classId, props. Get classId from [elementor://global-classes] resource.\n\nNaming pattern: [element-type]-[purpose/variant]-[modifier]\nDO NOT create global classes for: one-off styles, layout-specific properties.\n\nUse style schema at [elementor://styles/schema/{category}] for valid props. Errors include exact schema mismatch details.",schema:d,outputSchema:p,handler:handler})}},"./packages/packages/core/editor-global-classes/src/save-global-classes.tsx":function(e,s,t){t.r(s),t.d(s,{saveGlobalClasses:function(){return saveGlobalClasses}});var a=t("react"),r=t("@elementor/editor-ui"),o=t("@elementor/store"),n=t("@elementor/utils"),l=t("./packages/packages/core/editor-global-classes/src/api.ts"),c=t("./packages/packages/core/editor-global-classes/src/components/class-manager/duplicate-label-dialog.tsx"),i=t("./packages/packages/core/editor-global-classes/src/store.ts"),d=t("./packages/packages/core/editor-global-classes/src/utils/tracking.ts");async function saveGlobalClasses({context:e,onApprove:s}){const t=(0,i.selectData)((0,o.__getState)()),n="preview"===e?l.apiClient.saveDraft:l.apiClient.publish,p="preview"===e?i.selectPreviewInitialData:i.selectFrontendInitialData,u=await n({items:t.items,order:t.order,changes:calculateChanges(t,p((0,o.__getState)()))});(0,o.__dispatch)(i.slice.actions.reset({context:e})),u?.data?.data?.code===l.API_ERROR_CODES.DUPLICATED_LABEL&&((0,o.__dispatch)(i.slice.actions.updateMultiple(u.data.data.modifiedLabels)),(0,d.trackGlobalClasses)({event:"classPublishConflict",numOfConflicts:Object.keys(u.data.data.modifiedLabels).length}),(0,r.openDialog)({component:a.createElement(c.DuplicateLabelDialog,{modifiedLabels:u.data.data.modifiedLabels||[],onApprove:s})}))}function calculateChanges(e,s){const t=Object.keys(e.items),a=Object.keys(s.items);return{added:t.filter(e=>!a.includes(e)),deleted:a.filter(e=>!t.includes(e)),modified:t.filter(t=>t in s.items&&(0,n.hash)(e.items[t])!==(0,n.hash)(s.items[t]))}}},"./packages/packages/core/editor-global-classes/src/store.ts":function(e,s,t){t.r(s),t.d(s,{selectClass:function(){return selectClass},selectData:function(){return selectData},selectEmptyCssClass:function(){return u},selectFrontendInitialData:function(){return selectFrontendInitialData},selectGlobalClasses:function(){return d},selectIsDirty:function(){return selectIsDirty},selectOrder:function(){return i},selectOrderedClasses:function(){return p},selectPreviewInitialData:function(){return selectPreviewInitialData},slice:function(){return c}});var a=t("@elementor/editor-styles"),r=t("@elementor/store"),o=t("./packages/packages/core/editor-global-classes/src/errors.ts");const n=t("./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts").SnapshotHistory.get("global-classes"),l="globalClasses",c=(0,r.__createSlice)({name:l,initialState:{data:{items:{},order:[]},initialData:{frontend:{items:{},order:[]},preview:{items:{},order:[]}},isDirty:!1},reducers:{load(e,{payload:{frontend:s,preview:t}}){e.initialData.frontend=s,e.initialData.preview=t,e.data=t,e.isDirty=!1},add(e,{payload:s}){n.next(e.data),e.data.items[s.id]=s,e.data.order.unshift(s.id),e.isDirty=!0},delete(e,{payload:s}){n.next(e.data),e.data.items=Object.fromEntries(Object.entries(e.data.items).filter(([e])=>e!==s)),e.data.order=e.data.order.filter(e=>e!==s),e.isDirty=!0},setOrder(e,{payload:s}){n.next(e.data),e.data.order=s,e.isDirty=!0},update(e,{payload:s}){n.next(e.data);const t={...e.data.items[s.style.id],...s.style};e.data.items[s.style.id]=t,e.isDirty=!0},updateMultiple(e,{payload:s}){n.next(e.data),Object.entries(s).forEach(([s,{modified:t}])=>{e.data.items[s].label=t}),e.isDirty=!1},updateProps(e,{payload:s}){const t=e.data.items[s.id];if(!t)throw new o.GlobalClassNotFoundError({context:{styleId:s.id}});n.next(e.data);const r=(0,a.getVariantByMeta)(t,s.meta);let l=("custom_css"in s?s.custom_css:r?.custom_css)??null;if(l=l?.raw?l:null,r){const e=JSON.parse(JSON.stringify(r.props)),a=JSON.parse(JSON.stringify(s.props));r.props=mergeProps(e,a),r.custom_css=l,t.variants=getNonEmptyVariants(t)}else t.variants.push({meta:s.meta,props:s.props,custom_css:l});e.isDirty=!0},reset(e,{payload:{context:s}}){"frontend"===s&&(n.reset(),e.initialData.frontend=e.data,e.isDirty=!1),e.initialData.preview=e.data},undo(e){n.isLast()&&n.next(e.data);const s=n.prev();s?(e.data=s,e.isDirty=!0):e.data=e.initialData.preview},resetToInitialState(e,{payload:{context:s}}){n.reset(),e.data=e.initialData[s],e.isDirty=!1},redo(e){const s=n.next();n.isLast()&&n.prev(),s&&(e.data=s,e.isDirty=!0)}}}),mergeProps=(e,s)=>{const t=Array.isArray(e)?{}:e;return Object.entries(s).forEach(([e,s])=>{null==s?delete t[e]:t[e]=s}),t},getNonEmptyVariants=e=>e.variants.filter(({props:e,custom_css:s})=>Object.keys(e).length||s?.raw),selectData=e=>e[l].data,selectFrontendInitialData=e=>e[l].initialData.frontend,selectPreviewInitialData=e=>e[l].initialData.preview,i=(0,r.__createSelector)(selectData,({order:e})=>e),d=(0,r.__createSelector)(selectData,({items:e})=>e),selectIsDirty=e=>e[l].isDirty,p=(0,r.__createSelector)(d,i,(e,s)=>s.map(s=>e[s])),selectClass=(e,s)=>e[l].data.items[s]??null,u=(0,r.__createSelector)(selectData,({items:e})=>Object.values(e).filter(e=>0===e.variants.length))},"./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts":function(e,s,t){t.r(s),t.d(s,{syncWithDocumentSave:function(){return syncWithDocumentSave}});var a=t("@elementor/editor-current-user"),r=t("@elementor/editor-documents"),o=t("@elementor/editor-v1-adapters"),n=t("@elementor/store"),l=t("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=t("./packages/packages/core/editor-global-classes/src/save-global-classes.tsx"),i=t("./packages/packages/core/editor-global-classes/src/store.ts");function syncWithDocumentSave(e){const s=function syncDirtyState(){return(0,n.__subscribeWithSelector)(i.selectIsDirty,()=>{(function isDirty(){return(0,i.selectIsDirty)((0,n.__getState)())})()&&(0,r.setDocumentModifiedStatus)(!0)})}();return function bindSaveAction(e){(0,o.registerDataHook)("dependency","document/save/save",s=>{const t=(0,a.getCurrentUser)(),r=t?.capabilities.includes(l.UPDATE_CLASS_CAPABILITY_KEY);return!r||((0,c.saveGlobalClasses)({context:"publish"===s.status?"frontend":"preview",onApprove:e?.open}),!0)})}(e),s}},"./packages/packages/core/editor-global-classes/src/sync-with-document.tsx":function(e,s,t){t.r(s),t.d(s,{SyncWithDocumentSave:function(){return SyncWithDocumentSave}});var a=t("react"),r=t("@elementor/editor-v1-adapters"),o=t("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),n=t("./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts");function SyncWithDocumentSave(){const e=(0,o.usePanelActions)();return(0,a.useEffect)(()=>{(0,r.__privateListenTo)((0,r.v1ReadyEvent)(),()=>{(0,n.syncWithDocumentSave)(e)})},[]),null}},"./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts":function(e,s,t){function createLink({value:e,next:s,prev:t}){return{value:e,prev:t||null,next:s||null}}t.r(s),t.d(s,{SnapshotHistory:function(){return SnapshotHistory}});class SnapshotHistory{static registry={};static get(e){return SnapshotHistory.registry[e]||(SnapshotHistory.registry[e]=new SnapshotHistory(e)),SnapshotHistory.registry[e]}first=null;current=null;constructor(e){this.namespace=e}transform(e){return JSON.parse(JSON.stringify(e))}reset(){this.first=this.current=null}prev(){return this.current&&this.current!==this.first?(this.current=this.current.prev,this.current?.value||null):null}isLast(){return!this.current||!this.current.next}next(e){if(e){if(!this.current)return this.first=createLink({value:this.transform(e)}),this.current=this.first,this.current.value;const s=createLink({value:this.transform(e),prev:this.current});return this.current.next=s,this.current=s,this.current.value}return this.current&&this.current.next?(this.current=this.current.next,this.current.value):null}}},"./packages/packages/core/editor-global-classes/src/utils/tracking.ts":function(e,s,t){t.r(s),t.d(s,{trackGlobalClasses:function(){return trackGlobalClasses}});var a=t("@elementor/events"),r=t("@elementor/store"),o=t("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),n=t("./packages/packages/core/editor-global-classes/src/errors.ts"),l=t("./packages/packages/core/editor-global-classes/src/store.ts");const trackGlobalClasses=async e=>{const{runAction:s}=e,t=await getSanitizedData(e);t&&(track(t),"classCreated"===t.event&&"classId"in t&&fireClassApplied(t.classId)),s?.()},fireClassApplied=async e=>{const s=await getAppliedInfo(e);track({event:"classApplied",classId:e,...s,totalInstancesAfterApply:1})},getSanitizedData=async e=>{switch(e.event){case"classApplied":if("classId"in e&&e.classId){const s=await getAppliedInfo(e.classId);return{...e,...s}}break;case"classRemoved":if("classId"in e&&e.classId){const s=getRemovedInfo(e.classId);return{...e,...s}}break;case"classDeleted":if("classId"in e&&e.classId){const s=await trackDeleteClass(e.classId);return{...e,...s}}break;case"classCreated":return"source"in e&&"created"!==e.source&&"classId"in e&&e.classId?{...e,classTitle:getCssClass(e.classId).label}:e;case"classStateClicked":if("classId"in e&&e.classId)return{...e,classTitle:getCssClass(e.classId).label};break;default:return e}},track=e=>{const{dispatchEvent:s,config:t}=(0,a.getMixpanel)();if(!t?.names?.global_classes?.[e.event])return void console.error("Global class tracking event not found",{event:e.event});const r=t.names.global_classes[e.event],{event:o,...l}=e;try{s?.(r,{event:o,...l})}catch(e){throw new n.GlobalClassTrackingError({cause:e})}},extractCssClassData=e=>({classTitle:getCssClass(e).label}),getCssClass=e=>{const s=(0,l.selectClass)((0,r.__getState)(),e);if(!s)throw new Error(`CSS class with ID ${e} not found`);return s},trackDeleteClass=async e=>({totalInstances:await getTotalInstancesByCssClassID(e),classTitle:getCssClass(e).label}),getTotalInstancesByCssClassID=async e=>{const s=await(0,o.fetchCssClassUsage)();return s[e]?.total??1},getAppliedInfo=async e=>{const{classTitle:s}=extractCssClassData(e);return{classTitle:s,totalInstancesAfterApply:await getTotalInstancesByCssClassID(e)+1}},getRemovedInfo=e=>{const{classTitle:s}=extractCssClassData(e);return{classTitle:s}}},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-canvas":function(e){e.exports=window.elementorV2.editorCanvas},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-documents":function(e){e.exports=window.elementorV2.editorDocuments},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-styles-repository":function(e){e.exports=window.elementorV2.editorStylesRepository},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/events":function(e){e.exports=window.elementorV2.events},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/query":function(e){e.exports=window.elementorV2.query},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/store":function(e){e.exports=window.elementorV2.store},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},s={};function __webpack_require__(t){var a=s[t];if(void 0!==a)return a.exports;var r=s[t]={exports:{}};return e[t](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var s=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(s,{a:s}),s},__webpack_require__.d=function(e,s){for(var t in s)__webpack_require__.o(s,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:s[t]})},__webpack_require__.o=function(e,s){return Object.prototype.hasOwnProperty.call(e,s)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var t={};!function(){__webpack_require__.r(t),__webpack_require__.d(t,{GLOBAL_CLASSES_URI:function(){return e.GLOBAL_CLASSES_URI},init:function(){return s.init}});var e=__webpack_require__("./packages/packages/core/editor-global-classes/src/mcp-integration/classes-resource.ts"),s=__webpack_require__("./packages/packages/core/editor-global-classes/src/init.ts")}(),(window.elementorV2=window.elementorV2||{}).editorGlobalClasses=t}(),window.elementorV2.editorGlobalClasses?.init?.();
//# sourceMappingURL=editor-global-classes.js.map